*Title: Customizing the Appearance
*Slug: customizing-appearance
*Answers Common Question: Is there a way to brand activeCollab to match my company identity?

================================================================

activeCollab allows you to customize your working environment to suit your needs. Here are a few tips on how to do that quickly and easily:

<{sub}>Upload Your Company Logo in activeCollab<{/sub}>

Use your company logo to replace the default activeCollab logo throughout the application. Your company logo can be placed as:

- <{term}>System Logo<{/term}>  displayed in all emails sent out by the system -  Notifications, Welcome Messages, Invoices, etc.
- <{term}>Login Page Logo<{/term}> visible to all users logging in to activeCollab.
- <{term}>Favicon<{/term}> located on the tab in your browser.

To upload the logo, go to <{option}>Administration > Identity Settings<{/option}> and select the image file to upload:

<{image name="company_logo.png"}>

<{sub}>Change the Color Scheme<{/sub}>

To change the user interface color scheme, use the <{term}>Appearance<{/term}> tool:

<{step num=1}>Visit the <{option}>Administration > Appearance<{/option}> page.<{/step}>
<{step num=2}>Click the <{option}>Add New<{/option}> button.<{/step}>
<{step num=3}>Set the colors that you wish to use.<{/step}>
<{step num=4}>Click the <{option}>Use this Color Scheme<{/option}> button.<{/step}>

<{image name="color_scheme.png"}>

<{sub}>Welcome Messages<{/sub}>

There are two convenient ways to welcome new members to your Project collaboration hub:

**1. Personalized Welcome Email**

When you are inviting a <{term}>New User<{/term}> to your activeCollab you have the option to add a <{option}>Personalized Message<{/option}> to the invitation email. By doing so, the person will receive the login credentials followed by your welcome message. 

<{note title="Quick Tip"}>If you have already uploaded your company logo, the <{term}>Welcome Email<{/term}> sent to new users will display the logo in the message body.<{/note}>

**2. Dashboard Announcements**

Use the <{term}>Announcements<{/term}> tool available in the <{term}>Administration<{/term}> to post a message on the <{page name="dashboard" book="people"}>Dashboard<{/page}>.

Write the message and select the group of users, who will see it on their Dashboard (and, optionally, receive an email notification). After everything is set, just click the <{option}>Add Announcement<{/option}> button to post the notification:

<{image name="announcement.png"}>

<{sub}>Customize Your Invoices<{/sub}>

activeCollab can be used to create and issue professional looking Invoices. The outlook of Invoices is fully customizable. To learn how to edit the appearance of Invoices, please read <{page name="customize-invoices" book="invoicing"}>Customizing Invoices<{/page}>.

<{related_video name='my-activecollab'}> 
